/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm8260.DeviceView.BankLike;
import ibm.nways.jdm8260.DeviceView.Bank_12;
import ibm.nways.jdm8260.DeviceView.Bank_16;
import ibm.nways.jdm8260.DeviceView.Bank_8;
import ibm.nways.jdm8260.DeviceView.Bank_E1;
import ibm.nways.jdm8260.DeviceView.BayLike;
import ibm.nways.jdm8260.DeviceView.Bay_2;
import ibm.nways.jdm8260.DeviceView.FactoryLike;
import ibm.nways.jdm8260.DeviceView.Hub8250_06hc;
import ibm.nways.jdm8260.DeviceView.Hub8250_17;
import ibm.nways.jdm8260.DeviceView.Hub8260_10;
import ibm.nways.jdm8260.DeviceView.Hub8260_17;
import ibm.nways.jdm8260.DeviceView.Hub8260_7;
import ibm.nways.jdm8260.DeviceView.Hub8265_17;
import ibm.nways.jdm8260.DeviceView.HubLike;
import ibm.nways.jdm8260.DeviceView.HubUnknown;
import ibm.nways.jdm8260.DeviceView.ModuleLike;
import ibm.nways.jdm8260.DeviceView.ModuleUnknown;
import ibm.nways.jdm8260.DeviceView.Module_138000;
import ibm.nways.jdm8260.DeviceView.Module_161000;
import ibm.nways.jdm8260.DeviceView.Module_166000;
import ibm.nways.jdm8260.DeviceView.Module_167000;
import ibm.nways.jdm8260.DeviceView.Module_177000;
import ibm.nways.jdm8260.DeviceView.Module_180000;
import ibm.nways.jdm8260.DeviceView.Module_181000;
import ibm.nways.jdm8260.DeviceView.Module_960000;
import ibm.nways.jdm8260.DeviceView.Port;
import ibm.nways.jdm8260.DeviceView.PortATM;
import ibm.nways.jdm8260.DeviceView.PortBridge;
import ibm.nways.jdm8260.DeviceView.PortCACarrier;
import ibm.nways.jdm8260.DeviceView.PortLS;
import ibm.nways.jdm8260.DeviceView.PortLike;
import ibm.nways.jdm8260.DeviceView.PortTR;
import ibm.nways.jdm8260.Jdm8260SummaryInfo;
import ibm.nways.jdm8260.MibInfo;
import ibm.nways.jdm8260.MibValue;
import ibm.nways.ras.RAS;
import java.io.Serializable;

public class Factory
implements FactoryLike {
    private static final Factory factoryInstance = new Factory();
    public static String[][] atmCarrier1_0Modules = new String[][]{{"8281", "138001"}, {"6404B", "138001"}, {"5200", "138002"}, {"5300", "138002"}, {"8271", "138003"}, {"8030", "138003"}, {"8272", "138004"}, {"8031", "138004"}, {"5008", "138005"}, {"5400", "138006"}, {"8260E3 ", "138007"}, {"8260T3 ", "138007"}, {"8260OC3", "138007"}, {"8260STM", "138007"}, {"8032", "138008"}, {"8260014", "138008"}, {"8260018", "138008"}, {"8260024", "138008"}, {"8260028", "138008"}};
    public static String[][] atmCarrier1_5Modules = new String[][]{{"8260622", "161001"}, {"8260E1 ", "161002"}, {"8260T1 ", "161002"}, {"8260E3 ", "161002"}, {"8260T3 ", "161002"}, {"8260OC3", "161002"}, {"8260STM", "161002"}, {"IMA_E1 ", "161002"}, {"IMA_T1 ", "161002"}, {"OSCR000", "161003"}, {"6600", "161003"}};
    public static String[][] atmCarrier2_0Modules = new String[][]{{"8265622", "166001"}, {"6616", "166002"}, {"6617", "166003"}};
    public static String[][] atmCarrier2_5Modules = new String[][]{{"5200", "167001"}, {"5300", "167001"}, {"5400", "167002"}, {"5401", "167002"}, {"5403", "167002"}, {"8271", "167003"}, {"8030", "167003"}, {"8272", "167004"}, {"8031", "167004"}, {"5008", "167005"}, {"8260E3 ", "167006"}, {"8260T3 ", "167006"}, {"8260OC3", "167006"}, {"8260STM", "167006"}, {"8260E1 ", "167006"}, {"8260T1 ", "167006"}, {"IMA_E1 ", "167006"}, {"IMA_T1 ", "167006"}, {"8032", "167007"}, {"8260014", "167007"}, {"8260018", "167007"}, {"8260024", "167007"}, {"8260028", "167007"}, {"OSCR000", "167008"}, {"6600", "167008"}};
    public static String[][] atmCarrier2_5GenericModules = new String[][]{{"OSCR000", "177001"}, {"6600", "177001"}};
    public static String[][] atmCarrier2_5SymetricModules = new String[][]{{"OSCR000", "180001"}, {"6600", "180001"}};
    public static String[][] atmCarrier2_5AsymModules = new String[][]{{"5400", "181001"}, {"5401", "181001"}, {"5403", "181001"}, {"OSCR000", "181002"}, {"6600", "181002"}};
    public static String[][] carrierBays = new String[][]{{"8032", "100101"}, {"8260014", "100102"}, {"8260018", "100103"}, {"8260024", "100104"}, {"8260028", "100105"}, {"8260E3 ", "100106"}, {"8260T3 ", "100107"}, {"8260OC3", "100108"}, {"8260STM", "100109"}, {"8260E1 ", "100110"}, {"8260T1 ", "100111"}, {"IMA_E1 ", "100112"}, {"IMA_T1 ", "100113"}, {"OSCR000", "100114"}, {"6600", "100115"}};

    private Factory() {
    }

    public BayLike createBay(int n, int n2, int n3) {
        String string = "createBay";
        String string2 = "ibm.nways.jdm8260.DeviceView.Bay_" + n3;
        try {
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Creating bay class -> " + string2);
            }
            Class<?> clazz = Class.forName(string2);
            return (BayLike)clazz.newInstance();
        }
        catch (Exception exception) {
            RAS.trace(19, 2, this, string, "Bay Class " + string2 + " not found. Create BayUnknown class instead");
            return new Bay_2();
        }
    }

    public BankLike createBank(int n, int n2) {
        switch (n2) {
            case 2: {
                return new Bank_E1();
            }
            case 8: {
                return new Bank_8();
            }
            case 12: {
                return new Bank_12();
            }
            case 16: {
                return new Bank_16();
            }
        }
        throw new IllegalArgumentException("Unsupported number of ports for bank: " + n2);
    }

    public PortLike createPort(int n, int n2, String string) {
        switch (n) {
            case 14: 
            case 19: 
            case 20: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 59: 
            case 62: 
            case 67: 
            case 118: {
                return new PortTR();
            }
            case 9: 
            case 30: 
            case 31: 
            case 120: 
            case 121: {
                return new PortBridge(string);
            }
            case 138001: 
            case 138003: 
            case 138004: 
            case 167003: 
            case 167004: {
                return new PortCACarrier();
            }
            case 96: {
                return new PortLS(n2);
            }
            case 71: 
            case 72: 
            case 123: 
            case 125: 
            case 153: 
            case 164: 
            case 165: 
            case 100106: 
            case 100107: 
            case 100108: 
            case 100109: 
            case 100110: 
            case 100111: 
            case 100112: 
            case 100113: 
            case 138007: 
            case 161001: 
            case 161002: 
            case 166001: 
            case 167006: {
                return new PortATM();
            }
        }
        return new Port();
    }

    public static FactoryLike getInstance() {
        return factoryInstance;
    }

    public HubLike createHub(Serializable serializable, int n) {
        int n2;
        String string = "createHub";
        if (serializable instanceof SpecialValue) {
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Unknown sysObjectID -> " + serializable);
            }
            return new HubUnknown();
        }
        String string2 = serializable.toString();
        if (RAS.isEnabled(19, 2)) {
            RAS.trace(19, 2, this, string, "SysObjectID -> " + string2);
            RAS.trace(19, 2, this, string, "ConcType    -> " + n);
        }
        if ((n2 = Jdm8260SummaryInfo.modelFromSysOid(string2)) == -1) {
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Unknown sysObjectID -> " + serializable);
            }
            return new HubUnknown();
        }
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new Hub8250_06hc();
            }
            case 1: 
            case 9: {
                return new Hub8250_17();
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return new Hub8260_7();
            }
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return new Hub8260_10();
            }
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return new Hub8260_17();
            }
            case 34: {
                return new Hub8265_17();
            }
        }
        if (RAS.isEnabled(19, 2)) {
            RAS.trace(19, 2, this, string, "Unknown concType -> " + n);
        }
        return new HubUnknown();
    }

    public ModuleLike createModule(MibInfo mibInfo, int n, int n2, int n3) {
        String string = "createModule";
        String string2 = "ibm.nways.jdm8260.DeviceView.Module_";
        switch (n3) {
            case 63: {
                string2 = String.valueOf(string2) + this.create_TR_8229_8235Module63(mibInfo, n);
                break;
            }
            case 64: {
                string2 = String.valueOf(string2) + this.create_ETHER_8235Module64(mibInfo, n);
                break;
            }
            case 96: {
                string2 = String.valueOf(string2) + this.createLightSpeedModule96(mibInfo, n, n2);
                break;
            }
            case 107: {
                string2 = String.valueOf(string2) + this.createLightSpeedModule107(mibInfo, n, n2);
                break;
            }
            case 138: {
                string2 = String.valueOf(string2) + this.createAtmCarrier1_0Module(mibInfo, n, n2);
                break;
            }
            case 161: {
                string2 = String.valueOf(string2) + this.createAtmCarrier1_5Module(mibInfo, n, n2);
                break;
            }
            case 166: {
                string2 = String.valueOf(string2) + this.createAtmCarrier2_0Module(mibInfo, n, n2);
                break;
            }
            case 167: {
                string2 = String.valueOf(string2) + this.createAtmCarrier2_5Module(mibInfo, n, n2);
                break;
            }
            case 177: {
                string2 = String.valueOf(string2) + this.createAtmCarrier2_5GenericModule(mibInfo, n, n2);
                break;
            }
            case 180: {
                string2 = String.valueOf(string2) + this.createAtmCarrier2_5SymetricModule(mibInfo, n, n2);
                break;
            }
            case 181: {
                string2 = String.valueOf(string2) + this.createAtmCarrier2_5AsymModule(mibInfo, n, n2);
                break;
            }
            default: {
                string2 = String.valueOf(string2) + n3;
            }
        }
        try {
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Creating module class -> " + string2);
            }
            Class<?> clazz = Class.forName(string2);
            return (ModuleLike)clazz.newInstance();
        }
        catch (Exception exception) {
            RAS.trace(19, 2, this, string, "Module Class " + string2 + " not found. Create ModuleUnknown class instead");
            switch (n3) {
                case 96: 
                case 107: {
                    return new Module_960000();
                }
                case 138: {
                    return new Module_138000();
                }
                case 161: {
                    return new Module_161000();
                }
                case 166: {
                    return new Module_166000();
                }
                case 167: {
                    return new Module_167000();
                }
                case 177: {
                    return new Module_177000();
                }
                case 180: {
                    return new Module_180000();
                }
                case 181: {
                    return new Module_181000();
                }
            }
            return new ModuleUnknown();
        }
    }

    private int create_TR_8229_8235Module63(MibInfo mibInfo, int n) {
        String string = "." + n;
        Serializable serializable = mibInfo.getVar("t50TCModOEMType", string);
        int n2 = ((MibValue)serializable).getIntValue();
        return n2;
    }

    private int create_ETHER_8235Module64(MibInfo mibInfo, int n) {
        String string = "." + n;
        Serializable serializable = mibInfo.getVar("e50ECModOEMType", string);
        int n2 = ((MibValue)serializable).getIntValue();
        return n2;
    }

    private int createLightSpeedModule96(MibInfo mibInfo, int n, int n2) {
        String string = "." + n + "." + n2;
        Serializable serializable = mibInfo.getVar("sWLSModMezz1Status", string);
        Serializable serializable2 = mibInfo.getVar("sWLSModMezz2Status", string);
        return 960000 + ((MibValue)serializable).getIntValue() * 100 + ((MibValue)serializable2).getIntValue();
    }

    private int createLightSpeedModule107(MibInfo mibInfo, int n, int n2) {
        String string = "." + n + "." + n2;
        Serializable serializable = mibInfo.getVar("sWLS2ModMezz1Status", string);
        Serializable serializable2 = mibInfo.getVar("sWLS2ModMezz2Status", string);
        if (serializable instanceof SpecialValue || serializable2 instanceof SpecialValue) {
            serializable = mibInfo.getVar("sWLSModMezz1Status", string);
            serializable2 = mibInfo.getVar("sWLSModMezz2Status", string);
        }
        return 960000 + ((MibValue)serializable).getIntValue() * 100 + ((MibValue)serializable2).getIntValue();
    }

    public static int findAtmCarrierModule(String string, String[][] stringArray) {
        try {
            int n = 0;
            while (true) {
                if (stringArray[n][0].equals(string)) {
                    return Integer.parseInt(stringArray[n][1]);
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 2;
        }
    }

    public static int findAtmCarrierBay(String string) {
        try {
            int n = 0;
            while (true) {
                if (carrierBays[n][0].equals(string)) {
                    return Integer.parseInt(carrierBays[n][1]);
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 2;
        }
    }

    public static int findVegaUFCType(int n, int n2, int n3) {
        int n4 = 166000;
        if (n == 8 && n2 == 13) {
            if (n3 == 8) {
                n4 = 166001;
            } else if (n3 == 36) {
                n4 = 166002;
            }
        }
        return n4;
    }

    private int createAtmCarrier1_0Module(MibInfo mibInfo, int n, int n2) {
        Object object;
        int n3 = 2;
        String string = "." + n + "." + n2;
        Serializable serializable = mibInfo.getVar("aCARModEng1ModelNum", string);
        if (serializable instanceof MibValue) {
            object = ((MibValue)serializable).getValue().toString();
            n3 = Factory.findAtmCarrierModule((String)object, atmCarrier1_0Modules);
        }
        if (n3 == 2 && (object = mibInfo.getVar("aCARModEng2ModelNum", string)) instanceof MibValue) {
            String string2 = ((MibValue)object).getValue().toString();
            n3 = Factory.findAtmCarrierModule(string2, atmCarrier1_0Modules);
        }
        return n3;
    }

    private int createAtmCarrier1_5Module(MibInfo mibInfo, int n, int n2) {
        Object object;
        int n3 = 2;
        String string = "." + n + "." + n2;
        Serializable serializable = mibInfo.getVar("aCAR15ModEng1ModelNum", string);
        if (serializable instanceof MibValue) {
            object = ((MibValue)serializable).getValue().toString();
            n3 = Factory.findAtmCarrierModule((String)object, atmCarrier1_5Modules);
        }
        if (n3 == 2 && (object = mibInfo.getVar("aCAR15ModEng2ModelNum", string)) instanceof MibValue) {
            String string2 = ((MibValue)object).getValue().toString();
            n3 = Factory.findAtmCarrierModule(string2, atmCarrier1_5Modules);
        }
        return n3;
    }

    private int createAtmCarrier2_0Module(MibInfo mibInfo, int n, int n2) {
        int n3 = 2;
        String string = "." + n + "." + n2;
        Serializable serializable = mibInfo.getVar("aCAR15GGModEng1ModelNum", string);
        if (serializable instanceof MibValue) {
            String string2 = ((MibValue)serializable).getValue().toString();
            n3 = Factory.findAtmCarrierModule(string2, atmCarrier2_0Modules);
        }
        return n3;
    }

    private int createAtmCarrier2_5Module(MibInfo mibInfo, int n, int n2) {
        Object object;
        int n3 = 2;
        String string = "." + n + "." + n2;
        Serializable serializable = mibInfo.getVar("aCARGG2ModEng1ModelNum", string);
        if (serializable instanceof MibValue) {
            object = ((MibValue)serializable).getValue().toString();
            n3 = Factory.findAtmCarrierModule((String)object, atmCarrier2_5Modules);
        }
        if (n3 == 2 && (object = mibInfo.getVar("aCARGG2ModEng2ModelNum", string)) instanceof MibValue) {
            String string2 = ((MibValue)object).getValue().toString();
            n3 = Factory.findAtmCarrierModule(string2, atmCarrier2_5Modules);
        }
        return n3;
    }

    private int createAtmCarrier2_5GenericModule(MibInfo mibInfo, int n, int n2) {
        Object object;
        int n3 = 2;
        String string = "." + n + "." + n2;
        Serializable serializable = mibInfo.getVar("oc64nnM-carrier-GG25GenericModEng1ModelNum", string);
        if (serializable instanceof MibValue) {
            object = ((MibValue)serializable).getValue().toString();
            n3 = Factory.findAtmCarrierModule((String)object, atmCarrier2_5GenericModules);
        }
        if (n3 == 2 && (object = mibInfo.getVar("oc64nnM-carrier-GG25GenericModEng2ModelNum", string)) instanceof MibValue) {
            String string2 = ((MibValue)object).getValue().toString();
            n3 = Factory.findAtmCarrierModule(string2, atmCarrier2_5GenericModules);
        }
        return n3;
    }

    private int createAtmCarrier2_5SymetricModule(MibInfo mibInfo, int n, int n2) {
        Object object;
        int n3 = 2;
        String string = "." + n + "." + n2;
        Serializable serializable = mibInfo.getVar("oc64nnM-carrier-GG25SymetricModEng1ModelNum", string);
        if (serializable instanceof MibValue) {
            object = ((MibValue)serializable).getValue().toString();
            n3 = Factory.findAtmCarrierModule((String)object, atmCarrier2_5AsymModules);
        }
        if (n3 == 2 && (object = mibInfo.getVar("oc64nnM-carrier-GG25SymetricModEng2ModelNum", string)) instanceof MibValue) {
            String string2 = ((MibValue)object).getValue().toString();
            n3 = Factory.findAtmCarrierModule(string2, atmCarrier2_5AsymModules);
        }
        return n3;
    }

    private int createAtmCarrier2_5AsymModule(MibInfo mibInfo, int n, int n2) {
        Object object;
        int n3 = 2;
        String string = "." + n + "." + n2;
        Serializable serializable = mibInfo.getVar("oc64nnM-carrier-GG25AsymModEng1ModelNum", string);
        if (serializable instanceof MibValue) {
            object = ((MibValue)serializable).getValue().toString();
            n3 = Factory.findAtmCarrierModule((String)object, atmCarrier2_5AsymModules);
        }
        if (n3 == 2 && (object = mibInfo.getVar("oc64nnM-carrier-GG25AsymModEng2ModelNum", string)) instanceof MibValue) {
            String string2 = ((MibValue)object).getValue().toString();
            n3 = Factory.findAtmCarrierModule(string2, atmCarrier2_5AsymModules);
        }
        return n3;
    }
}

